unit TransferRequestFormUnit;
{
    UNIT TransferRequestFormUnit;
    Version number 1.0.

This unit contains YAFTP Transfer Request form and it's handling
routines.
Created by Pter Karsai }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TTransReqForm = class(TForm)
{ form controls }
    Image1: TImage; Image2: TImage;
    GroupBox1: TGroupBox;
    Label1: TLabel; Label2: TLabel; Label3: TLabel;  Label4: TLabel;
    Label5: TLabel; Label6: TLabel; Label7: TLabel;
    FileNameL   : TLabel; FileSizeL: TLabel; FileDateL: TLabel;
    ToDirectoryL: TLabel;
    TransferB: TButton; AddToSchedulerB: TButton; CancelB: TButton;

    procedure TransferBClick(Sender: TObject);
    procedure AddToSchedulerBClick(Sender: TObject);
    procedure CancelBClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  public
   ClickedButton : byte;  { value of pressed button }
{ ----------------------------------------------------------------------------}
{ public methods, event handlers }
{ ----------------------------------------------------------------------------}
   procedure ShowData(IsDown:boolean; FileName,FileSize,FileDate,ToDir: string);
{ Function: Shows form data. If IsDown parameter is TRUE, TransferB will refer
  to Download, else Upload. More parameters by the minds :) }

   function RunDialog: byte;
{ Function: show TransReqForm and return with the button pressed. }
end;

{------------------------------------------------------------------------------}

var
  TransReqForm: TTransReqForm;

implementation
{$R *.DFM}
uses FTPFormUnit;

{------------------------------------------------------------------------------}

procedure TTransReqForm.ShowData(IsDown: boolean; FileName, FileSize, FileDate,
                                 ToDir: string);
begin
{ show all available data }
    FileNameL.Caption    := FileName;
    FileSizeL.Caption    := FileSize;
    FileDateL.Caption    := FileDate;
    ToDirectoryL.Caption := ToDir;

{ set button caption }
    if IsDown then
       TransferB.Caption:= '&Download'
    else
       TransferB.Caption:= '&Upload';
end;

{------------------------------------------------------------------------------}

function TTransReqForm.RunDialog: byte;
begin
{ startup: no button pressed }
    ClickedButton:= drNoButton;
{ show form and disable main FTP window }
    TransReqForm.Show;
    FTPForm.Enabled:= false;
{ we're waiting 'till user press a button or close form }
    while ClickedButton = drNoButton do begin
          Application.ProcessMessages;
          if Application.Terminated then exit;
    end;
{ just return with clicked button constant }
    FTPForm.Enabled:= true;  { we want to click more and more :) }
    Result:= ClickedButton;
end;

{------------------------------------------------------------------------------}

procedure TTransReqForm.TransferBClick(Sender: TObject);
begin
    ClickedButton:= drTransfer;
    TransReqForm.Close;
end;

{------------------------------------------------------------------------------}

procedure TTransReqForm.AddToSchedulerBClick(Sender: TObject);
begin
    ClickedButton:= drAddToScheduler;
    TransReqForm.Close;
end;

{------------------------------------------------------------------------------}

procedure TTransReqForm.CancelBClick(Sender: TObject);
begin
    ClickedButton:= drCancel;
    TransReqForm.Close;
end;

{------------------------------------------------------------------------------}

procedure TTransReqForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    if ClickedButton = drNoButton then ClickedButton:= drCancel;
end;

end.
